% Nise, N.S. 
% Control Systems Engineering, 7th ed. 
% John Wiley & Sons, Hoboken, NJ, 07030
%
% Control Systems Engineering Toolbox Version 7.0 
% Copyright  2015 by John Wiley & Sons, Inc.

% TryIt 11.3
% Use MATLAB, the Control System Toolbox, and the following statements to
% solve Skill-Assessment Exercise 11.3.

'TryIt 11.3'
pos=20
Ts=0.2
z=(-log(pos/100))/(sqrt(pi^2+log(pos/100)^2))
Pm=atan(2*z/(sqrt(-2*z^2+sqrt(1+4*z^4))))*(180/pi)
Wbw=(4/(Ts*z))*sqrt((1-2*z^2)+sqrt(4*z^4-4*z^2+2))
K=50*50*120
G=zpk([],[0,-50,-120],K)
sisotool(G,1)

% When the SISO Design for SISO Design Task Window appears:
% 1. Right-click on the Bode plot area and select Grid.
% 2. Note the phase margin and bandwidth shown in the MATLAB 
%    Command Window.
% 3. On the SISO Design for SISO Design Task Window toolbar, 
%    click on the red pole.
% 4. Place the pole of the compensator by click- ing on the 
%    gain plot at a frequency that is to the right of the 
%    desired bandwidth found in Step 2.
% 5. On the SISO Design for SISO Design Task Window toolbar, 
%    click on the red zero.
% 6. Place the zero of the compensator by click- ing on the
%    gain plot to the left of the desired bandwidth.
% 7. Reshape the Bode plots: alternately grab the pole and the 
%    zero with the mouse and alternately move them along the 
%    phase plot until the phase plot show a P.M. equal to that 
%    found in Step 2 and a phase-margin frequency close to the 
%    bandwidth found in Step 2.
% 8. Right-click in the Bode plot area and select Edit Compensator . . .
% 9. Read the lead compen- sator in the Control and Estimation Tools 
%    Manager Window.